<?php
/*--------------------------------------------------------------------
 Reader.php 2020-06-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Repository\Readers;

use Doctrine\DBAL\Connection;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\PropertiesCombinationIdDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\CombinationModelDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Exceptions\PropertiesCombinationIdDoesNotExistException;

/**
 * Class Reader
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Repository\Readers
 */
class Reader implements ReaderInterface
{
    /**
     * @var Connection
     */
    protected $connection;
    
    
    /**
     * Reader constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function combinationModel(PropertiesCombinationIdDto $combinationIdDto): CombinationModelDto
    {
        $combinationId = $combinationIdDto->combinationId();
        
        $modelResult = $this->connection->createQueryBuilder()
            ->select('combi_model')
            ->from('products_properties_combis')
            ->where('products_properties_combis_id=' . $combinationId)
            ->execute();
        
        if ($modelResult->rowCount() === 0) {
            
            throw new PropertiesCombinationIdDoesNotExistException('No entry in Database for products_properties_combis_id ' . $combinationId);
        }
        
        $model = $modelResult->fetch(0)['combi_model'];
        
        return new CombinationModelDto($model);
    }
}